<?php

namespace Mtc\Coupons\Types;

/**
 * Class AmountOffAll
 * @package Mtc\Coupons\Types
 */
class AmountOffAll extends CouponTypeBase
{
    /**
     * Get Total Discounted Amount
     *
     * @return float
     */
    protected function getDiscountedAmount()
    {
        $coupon = $this->coupon->getModel();
        return $coupon->deductable_amount < $coupon->value ? $coupon->deductable_amount : $coupon->value;
    }

    /**
     * Get Discounted values for item line
     *
     * @param $coupon
     * @param $item
     * @return float
     */
    public function getDiscountedValues($coupon, $item)
    {
        $quantity = $item->basket->items->sum('quantity');
        return [
            'discounted_amount' => round($coupon->value / $quantity, 2) * $item->quantity,
        ];
    }
}
