<?php

namespace Mtc\Coupons\Validators;

use Mtc\Coupons\Coupon;
use Mtc\Members\Facades\MemberAuth;

/**
 * Class MembersOnly
 * @package Mtc\Coupons\Validators
 */
class MembersOnly
{
    /**
     * @var
     */
    protected $basket;

    /**
     * @var
     */
    protected $member;

    /**
     * @param Coupon $coupon
     * @param $basket
     * @return bool
     */
    public function validate(Coupon $coupon, $basket)
    {
        //Check if first purchase enabled
        if (!$coupon->getBasicRestriction('members_only')) {
            return true;
        }

        //Check if member
        if (MemberAuth::check()) {
            return true;
        }

        return false;
    }
}
