<?php

namespace Mtc\Coupons\Validators;

use Illuminate\Support\Facades\App;
use Mtc\Coupons\Coupon;
use Mtc\Members\Facades\MemberAuth;
use Mtc\Orders\Contracts\OrderContract;

/**
 * Class FirstPurchase
 * @package Mtc\Coupons\Validators
 */
class FirstPurchase
{
    /**
     * @var
     */
    protected $basket;

    /**
     * @var
     */
    protected $member;

    /**
     * @param Coupon $coupon
     * @param $basket
     * @return bool
     */
    public function validate(Coupon $coupon, $basket)
    {
        //Check if first purchase enabled
        if (!$coupon->getBasicRestriction('only_first_purchase')) {
            return true;
        }

        $this->basket = $basket;
        $this->member = MemberAuth::user();

        //Check if there is member|email (If not, then validation fail - can not check for purchases)
        if (!$this->basket->email && !$this->member) {
            return false;
        }

        //Check if there are purchases by member|email (If there are, then validation fail)
        if ($this->checkPurchases()) {
            return false;
        }

        return true;
    }

    /**
     * Check purchases from orders
     *
     * @return bool
     */
    protected function checkPurchases()
    {
        $orders_query = App::make(OrderContract::class)->query();

        //Check if there is orders with basket email
        if ($this->basket->email) {
            $orders_query = $orders_query->where('email', $this->basket->email);
        }

        //Check if there is orders for logged in member
        if ($this->member) {
            $orders_query = $orders_query->orWhere('member_id', $this->member->id);
        }

        return (bool)$orders_query->count();
    }
}
