<?php

namespace Mtc\Crm\Contracts;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Support\Collection;
use Illuminate\Support\Facades\Config;
use Mtc\Crm\Factories\FormSectionFactory;

/**
 * @property Collection $questions
 * @property ?FormModel $form
 */
abstract class FormSectionModel extends Model
{
    use HasFactory;

    /**
     * @var string
     */
    protected $table = 'form_sections';

    /**
     * @var string[]
     */
    protected $guarded = [
        'id'
    ];

    protected $casts = [
        'settings' => 'array',
    ];

    /**
     * Model Factory
     *
     * @return FormSectionFactory
     */
    protected static function newFactory()
    {
        return FormSectionFactory::new();
    }

    /**
     * Relationship with questions
     *
     * @return BelongsTo
     */
    public function form(): BelongsTo
    {
        return $this->belongsTo(Config::get('crm.form_model'));
    }

    /**
     * Relationship with questions
     *
     * @return HasMany
     */
    public function questions(): HasMany
    {
        return $this->hasMany(Config::get('crm.form_question_model'))
            ->orderBy('order');
    }
}
