<?php

namespace Mtc\Crm\Contracts;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsToMany;
use Illuminate\Support\Facades\Config;
use Mtc\Crm\Factories\EnquiryTagFactory;

abstract class EnquiryTagModel extends Model
{
    use HasFactory;

    /**
     * @var string
     */
    protected $table = 'enquiry_tags';

    /**
     * @var string[]
     */
    protected $fillable = [
        'name',
    ];

    /**
     * Model Factory
     *
     * @return EnquiryTagFactory
     */
    protected static function newFactory()
    {
        return EnquiryTagFactory::new();
    }

    /**
     * Relationship with enquiries that have this tag
     *
     * @return BelongsToMany
     */
    public function enquiries(): BelongsToMany
    {
        return $this->belongsToMany(Config::get('crm.enquiry_model'), 'enquiry_assigned_tags');
    }
}
