<?php

namespace Mtc\Crm\Contracts;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Support\Facades\Config;
use Mtc\Crm\Factories\FormQuestionFactory;

abstract class FormQuestionModel extends Model
{
    use HasFactory;

    /**
     * @var string
     */
    protected $table = 'form_questions';

    /**
     * @var string[]
     */
    protected $guarded = [
        'id'
    ];

    /**
     * Cast attributes to types
     *
     * @var string[]
     */
    protected $casts = [
        'data' => 'array',
        'validation' => 'array',
        'settings' => 'array',
        'answer_options' => 'array',
    ];

    /**
     * Model factory
     *
     * @return FormQuestionFactory
     */
    protected static function newFactory()
    {
        return FormQuestionFactory::new();
    }

    /**
     * Relationship with questions
     *
     * @return BelongsTo
     */
    public function form(): BelongsTo
    {
        return $this->belongsTo(Config::get('crm.form_model'));
    }

    /**
     * Relationship with questions
     *
     * @return BelongsTo
     */
    public function section(): BelongsTo
    {
        return $this->belongsTo(Config::get('crm.form_section_model'), 'form_section_id');
    }
}
