<?php

namespace Mtc\Crm\Contracts;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Mtc\MercuryDataModels\Enquiry;

abstract class CustomerNote extends Model
{
    /**
     * Table name
     *
     * @var string
     */
    protected $table = 'customer_notes';

    /**
     * Mass assign attributes
     *
     * @var string[]
     */
    protected $fillable = [
        'customer_id',
        'author_id',
        'type',
        'severity',
        'details',
    ];

    public function customer(): BelongsTo
    {
        return $this->belongsTo(config('crm.customer_model'), 'customer_id');
    }

    public function author(): BelongsTo
    {
        return $this->belongsTo(config('crm.user_model'), 'author_id');
    }
}
