<?php

namespace Mtc\Crm\Facades;

use Illuminate\Contracts\Pagination\LengthAwarePaginator;
use Illuminate\Support\Collection;
use Illuminate\Support\Facades\Facade;
use Mtc\Crm\Contracts\EnquiryStatusModel;
use Mtc\Crm\Contracts\EnquiryTagModel;
use Mtc\Crm\Contracts\EnquiryTypeModel;
use Mtc\Crm\EnquiryDataRepository;

/**
 * @method static LengthAwarePaginator getTypes()
 * @method static EnquiryTypeModel getTypeModel()
 * @method static EnquiryTypeModel findType(int $id)
 * @method static EnquiryTypeModel addType(string $name, null|string $template_name = null)
 * @method static bool updateType(int $id, string $name, null|string $template_name = null)
 * @method static bool removeType(int $id)
 * @method static Collection getTags()
 * @method static EnquiryTagModel findTag(int $id)
 * @method static EnquiryTagModel addTag(string $name)
 * @method static bool updateTag(int $id, string $name)
 * @method static bool removeTag(int $id)
 * @method static Collection getStatuses()
 * @method static EnquiryStatusModel getStatusModel()
 * @method static EnquiryStatusModel findStatus(int $id)
 * @method static EnquiryStatusModel addStatus(string $name, bool $is_final = false, bool $is_initial = false)
 * @method static bool updateStatus(int $id, string $name, bool $is_final)
 * @method static bool removeStatus(int $id)
 * @see EnquiryDataRepository
 */
class EnquiryData extends Facade
{
    /**
     * Define the facade accessor
     *
     * @return string
     */
    protected static function getFacadeAccessor(): string
    {
        return 'enquiry-data';
    }
}
