<?php

namespace Mtc\Crm\Factories;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Factories\Factory;
use Mtc\Crm\Models\EnquiryAction;
use Mtc\Crm\Models\FormAction;

class EnquiryActionFactory extends Factory
{
    protected $model = EnquiryAction::class;

    /**
     * Define the model's default state.
     *
     * @return array
     * @throws \Exception
     */
    public function definition(): array
    {
        $success = random_int(0, 1);
        return [
            'enquiry_id' => random_int(1, 10),
            'action_name' => $this->faker->domainName,
            'data' => json_encode([]),
            'processed_at' => $success ? Carbon::now()->subMinutes(random_int(0, 2000)) : null,
            'failed_at' => $success ? null : Carbon::now()->subMinutes(random_int(0, 2000)),
            'context' => $this->faker->sentence(),
        ];
    }
}
