<?php

namespace Mtc\Crm\Contracts;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Support\Facades\Config;
use Mtc\Crm\Factories\FormFactory;

abstract class FormModel extends Model
{
    use SoftDeletes;
    use HasFactory;

    /**
     * @var string
     */
    protected $table = 'forms';

    /**
     * @var string[]
     */
    protected $guarded = [
        'id'
    ];

    /**
     * Model Factory
     *
     * @return FormFactory
     */
    protected static function newFactory()
    {
        return FormFactory::new();
    }

    /**
     * Relationship with questions
     *
     * @return HasMany
     */
    public function questions(): HasMany
    {
        return $this->hasMany(Config::get('crm.form_question_model'));
    }

    /**
     * Relationship with sections
     *
     * @return HasMany
     */
    public function sections(): HasMany
    {
        return $this->hasMany(Config::get('crm.form_section_model'));
    }

    /**
     * Relationship with form actions
     *
     * @return HasMany
     */
    public function actions(): HasMany
    {
        return $this->hasMany(Config::get('crm.form_action_model'));
    }
}
