<?php

namespace Mtc\Crm\Traits;

use Illuminate\Support\Facades\Log;
use Mtc\Crm\Models\Customer;

trait RetrievesCustomerId
{
    public function getCustomerId(?string $email, array $details = []): ?int
    {
        if (empty($email)) {
            return null;
        }
        try {
            $customer = Customer::query()->where('email', $email)->first();
            return $customer ? $customer->id : $this->createCustomerRecord($email, $details)->id;
        } catch (\Exception $exception) {
            Log:: error('Unable to find/create customer record: ' . $exception->getMessage());
        }
        return null;
    }

    private function createCustomerRecord(string $email, array $details = []): Customer
    {
        $customer = new Customer([
            'email' => $email,
            ...$details,
        ]);
        $customer->save();
        return $customer;
    }
}
