@extends('crm::emails.layout', [
    'subject' => $enquiry->subject ?? 'Thank you for your enquiry',
    'site_name' => $site_name,
    'site_logo' => $site_logo,
    'colours' => $colours,
])

@section('content')

{{-- TODO: Refactor to use a template / WYSIWYG editor in admin --}}

    <tr>
        <td colspan="2">
            <h2>What happens next?</h2>

            <p><strong>
Your request has now been passed on to the appropriate department and a representative will aim to get back to you within 30 minutes (during opening hours).</strong></p>

            <p>Our online advisors are available:</p>

            <p>
                <strong>Monday - Thursday:</strong> 8.00 to 19.00<br/>
                <strong>Friday - Saturday:</strong> 8.00 to 18.00<br/>
                <strong>Sunday:</strong> 11.00 to 17.00
            </p>

            <p>
                In the meantime please join our journey on <a href="https://www.facebook.com/PeterVardy/" target="_blank" rel="noopener noreferrer">Facebook</a>, <a href="https://twitter.com/petervardy/" target="_blank" rel="noopener noreferrer">X</a> and <a href="https://instagram.com/petervardy/" target="_blank" rel="noopener noreferrer">Instagram</a> or take a look at our latest videos on <a href="https://www.youtube.com/channel/UCyXNHld3U5_gQdqfnMtHQuw" target="_blank" rel="noopener noreferrer">YouTube</a>.
            </p>

            <p>If you have any issues with the service you have received and wish to speak to a member of the Customer Service team please contact us on <a href="tel:03308182688">0330 818 2688.</a></p>

            <p>
                Yours sincerely,<br/>
                Paula Mitchell<br/>
                Online Sales Manager
            </p>
        </td>
    </tr>
    
@endsection

@section('footer')
    <tr>
        <td colspan="2" align="center" class="smallText">
            <p>
                <strong>Peter Vardy Ltd</strong><br/>
                Pioneer House 2 Renshaw Place<br/>
                Holytown<br/>
                Motherwell<br/>
                ML1 4UF
            </p>

            <p>
                Registered In: Scotland<br/>
                Reg Company No: SC319442 (Scotland)<br/>
                Vat Reg No: 882944478
            </p>
        </td>
    <tr/>

@endsection

