<?php

namespace Mtc\Crm\Console\Commands;

use Mtc\Crm\Jobs\ProcessIncomingEnquiryJob;
use Illuminate\Console\Command;
use Illuminate\Foundation\Bus\DispatchesJobs;
use Mtc\MercuryDataModels\Enquiry;

class IngestEnquiries extends Command
{
    use DispatchesJobs;

    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'enquiries:ingest';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Process new incoming enquiries';

    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {
        Enquiry::query()
            ->whereNull('ingested_at')
            ->get()
            ->each(fn(Enquiry $enquiry) => $this->dispatch(new ProcessIncomingEnquiryJob($enquiry)));

        return 0;
    }
}
