<?php

namespace Mtc\Crm\Seeds;

use Illuminate\Database\Seeder;
use Mtc\Crm\Facades\EnquiryData;

class EnquiryStatusSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        collect($this->entries())
            ->each(fn(array $entry) => EnquiryData::addStatus($entry['name'], $entry['is_final'], $entry['is_initial']));
    }

    private function entries(): array
    {
        return [
            [
                'name' => 'New',
                'is_initial' => true,
                'is_final' => false,
            ],
            [
                'name' => 'Responded',
                'is_initial' => false,
                'is_final' => false,
            ],
            [
                'name' => 'Waiting for feedback',
                'is_initial' => false,
                'is_final' => false,
            ],
            [
                'name' => 'Closed',
                'is_initial' => false,
                'is_final' => true,
            ],
        ];
    }
}
