<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateEnquiryTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('enquiries', function (Blueprint $table) {
            $table->id();
            $table->nullableMorphs('reason');
            $table->unsignedBigInteger('form_id')->index()->nullable();
            $table->dateTime('ingested_at')->nullable()->index();
            $table->string('email')->nullable()->index();
            $table->nullableMorphs('submitter');
            $table->unsignedBigInteger('type_id')->index()->nullable();
            $table->unsignedBigInteger('status_id')->index()->nullable();
            $table->string('title')->nullable();
            $table->text('message')->nullable();
            $table->longText('details')->nullable();
            $table->longText('data')->nullable();
            $table->unsignedBigInteger('assigned_user_id')->nullable()->index();
            $table->unsignedBigInteger('customer_id')->nullable()->index();
            $table->timestamps();
            $table->softDeletes();
        });

        Schema::create('enquiry_status_history', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('enquiry_id')->index()->nullable();
            $table->unsignedBigInteger('status_id')->index();
            $table->unsignedBigInteger('user_id')->index()->nullable();
            $table->boolean('from_customer')->nullable()->index();
            $table->timestamps();
        });

        Schema::create('enquiry_messages', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('enquiry_id')->index()->nullable();
            $table->unsignedBigInteger('user_id')->index()->nullable();
            $table->unsignedBigInteger('new_status_id')->index()->nullable();
            $table->boolean('from_customer')->nullable()->index();
            $table->text('message')->nullable();
            $table->timestamps();
        });

        Schema::create('enquiry_subscribers', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('enquiry_id')->index();
            $table->unsignedBigInteger('user_id')->index();
        });

        Schema::create('enquiry_actions', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('enquiry_id')->index();
            $table->string('action_name')->index();
            $table->text('data')->nullable();
            $table->dateTime('processed_at')->nullable()->index();
            $table->dateTime('failed_at')->nullable()->index();
            $table->string('context', 500)->nullable();
            $table->timestamps();
        });

        Schema::create('enquiry_assigned_tags', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('enquiry_id');
            $table->unsignedBigInteger('enquiry_tag_id');
            $table->timestamps();
            $table->index(['enquiry_id', 'enquiry_tag_id']);
        });

        Schema::create('enquiry_tags', function (Blueprint $table) {
            $table->id();
            $table->string('name')->index();
            $table->timestamps();
        });

        Schema::create('enquiry_statuses', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->boolean('is_final')->nullable()->index();
            $table->timestamps();
        });

        Schema::create('enquiry_types', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->string('notes')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('enquiries');
        Schema::dropIfExists('enquiry_status_history');
        Schema::dropIfExists('enquiry_messages');
        Schema::dropIfExists('enquiry_subscribers');
        Schema::dropIfExists('enquiry_actions');
        Schema::dropIfExists('enquiry_assigned_tags');
        Schema::dropIfExists('enquiry_tags');
        Schema::dropIfExists('enquiry_statuses');
        Schema::dropIfExists('enquiry_types');
    }
}
