<?php

namespace Mtc\Crm\Http\Controllers;

use Illuminate\Foundation\Validation\ValidatesRequests;
use Illuminate\Support\Collection;
use Mtc\Crm\Contracts\EnquiryStatusModel;
use Mtc\Crm\Facades\EnquiryData;
use Mtc\Crm\Http\Requests\EnquiryStatusRequest;

class EnquiryStatusController
{
    use ValidatesRequests;

    /**
     * List enquiry statuses
     *
     * @return Collection
     */
    public function index(): Collection
    {
        return EnquiryData::getStatuses();
    }

    /**
     * Store an enquiry status
     *
     * @param EnquiryStatusRequest $request
     * @return EnquiryStatusModel
     */
    public function store(EnquiryStatusRequest $request): EnquiryStatusModel
    {
        return EnquiryData::addStatus($request->input('name'), $request->has('is_final'));
    }

    /**
     * Show enquiry status
     *
     * @param int $id
     * @return EnquiryStatusModel
     */
    public function show(int $id): EnquiryStatusModel
    {
        return EnquiryData::findStatus($id);
    }

    /**
     * Update enquiry status
     *
     * @param EnquiryStatusRequest $request
     * @param int $id
     * @return bool
     */
    public function update(EnquiryStatusRequest $request, int $id): bool
    {
        return EnquiryData::updateStatus($id, $request->input('name'), $request->has('is_final'));
    }

    /**
     * Remove enquiry status
     *
     * @param int $id
     * @return bool
     */
    public function destroy(int $id): bool
    {
        return EnquiryData::removeStatus($id);
    }
}
