<?php

namespace Mtc\Crm\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Support\Facades\App;
use Illuminate\Support\Facades\Auth;

class FormUpdateRequest extends FormRequest
{
    protected array $action_rules = [];

    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return Auth::check();
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return array_merge([
            'type_id' => [
                'required',
                'numeric',
                'exists:enquiry_types,id',
            ],
            'initial_status_id' => [
                'required',
                'numeric',
                'exists:enquiry_statuses,id',
            ],
            'initial_assignee' => [
                'sometimes',
                'numeric',
            ],
            'success_message' => 'present',
        ], $this->action_rules);
    }

    protected function prepareForValidation()
    {
        $extra_rules = collect([]);
        collect(config('crm.form_actions'))
            ->filter(fn ($class, $key) => $this->input("actions.$key.enabled"))
            ->map(fn($class) => App::make($class)->formAdditionalDataFields() ?? [])
            ->each(fn($fields, $key) => collect($fields)
                ->filter(fn($field) => !empty($field['validation']))
                ->each(fn($rules, $field_name) => $extra_rules
                    ->put("actions.$key.$field_name", $rules['validation'])));
        $this->action_rules = $extra_rules->toArray();
    }
}
