<?php

namespace Mtc\Crm\Contracts;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Support\Facades\Config;
use Mtc\Crm\Factories\EnquiryActionFactory;

abstract class EnquiryActionModel extends Model
{
    use HasFactory;

    /**
     * @var string
     */
    protected $table = 'enquiry_actions';

    /**
     * @var string[]
     */
    protected $fillable = [
        'enquiry_id',
        'action_name',
        'data',
        'processed_at',
        'failed_at',
        'context',
    ];

    protected $casts = [
        'data' => 'array',
        'processed_at' => 'datetime',
        'failed_at' => 'datetime',
    ];

    /**
     * Model factory
     *
     * @return EnquiryActionFactory
     */
    protected static function newFactory(): EnquiryActionFactory
    {
        return EnquiryActionFactory::new();
    }

    /**
     * Relationship with enquiry
     *
     * @return BelongsTo
     */
    public function enquiry(): BelongsTo
    {
        return $this->belongsTo(Config::get('crm.enquiry_model'), 'enquiry_id');
    }
}
