<?php

namespace Mtc\Crm\Contracts;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Support\Facades\Config;
use Mtc\Crm\Factories\EnquiryTypeFactory;

abstract class EnquiryTypeModel extends Model
{
    use HasFactory;

    /**
     * @var string
     */
    protected $table = 'enquiry_types';

    /**
     * @var string[]
     */
    protected $fillable = [
        'name',
        'notes',
    ];

    /**
     * Model factory
     *
     * @return EnquiryTypeFactory
     */
    protected static function newFactory()
    {
        return EnquiryTypeFactory::new();
    }

    /**
     * Relationship with enquiries that have this type
     *
     * @return HasMany
     */
    public function enquiries(): HasMany
    {
        return $this->hasMany(Config::get('crm.enquiry_model'), 'type_id');
    }
}
