<?php

namespace Mtc\Crm;

use Illuminate\Http\Request;
use Illuminate\Support\Collection;
use Illuminate\Support\Facades\DB;
use Mtc\Crm\Contracts\FormModel;

class FormRepository
{
    /**
     * Update form from request
     *
     * @param Request $request
     * @param FormModel $form
     * @return void
     */
    public function update(Request $request, FormModel $form)
    {
        DB::beginTransaction();
        $form->update([
            'type_id' => $request->input('type_id'),
            'initial_status_id' => $request->input('initial_status_id'),
            'initial_assignee' => $request->input('initial_assignee'),
            'success_message' => $request->input('success_message'),
        ]);

        $this->syncActions(collect($request->input('actions', [])), $form);
        DB::commit();
    }

    /**
     * Sync actions of the form
     *
     * @param Collection $actions
     * @param FormModel $form
     * @return void
     */
    protected function syncActions(Collection $actions, FormModel $form)
    {
        $enabled_forms = $actions
            ->filter(fn($action) => $action['enabled'] ?? false);

        $form->actions()
            ->whereNotIn('action_name', $enabled_forms->keys())
            ->delete();

        $enabled_forms->each(fn ($fields, $name) => $form->actions()
            ->updateOrCreate([
                'action_name' => $name,
            ], [
                'fields' => $fields,
            ]));
    }
}
