<?php

use Illuminate\Routing\Router;
use Mtc\Crm\Http\Controllers\EnquiryController;
use Mtc\Crm\Http\Controllers\EnquiryStatusController;
use Mtc\Crm\Http\Controllers\EnquiryTagController;
use Mtc\Crm\Http\Controllers\EnquiryTypeController;
use Mtc\Crm\Http\Controllers\FormController;

/** @var Router $router */
$router->group([
    'prefix' => config('admin.route_prefix'),
], function (Router $router) {

    $router->middleware(config('pages.route_middleware.pages'))
        ->group(function (Router $router) {
            $router->get('crm/enquiries/users-to-subscribe', [EnquiryController::class, 'usersToSubscribe'])
                ->name('enquiries.users-to-subscribe');
            $router->delete(
                'crm/enquiries/{enquiry}/subscribers/{subscriber}',
                [EnquiryController::class, 'unsubscribe']
            )
                ->name('enquiries.subscribers.destroy');
            $router->post('crm/enquiries/{enquiry}/action/{action}', [EnquiryController::class, 'resubmitAction'])
                ->name('enquiries.resubmit-action');
            $router->post('crm/enquiries/{enquiry}/add-tag/{tag}', [EnquiryController::class, 'addTag'])
                ->name('enquiries.add-tag');
            $router->post('crm/enquiries/{enquiry}/remove-tag/{tag}', [EnquiryController::class, 'removeTag'])
                ->name('enquiries.remove-tag');
            $router->post('crm/enquiries/{enquiry}/assign', [EnquiryController::class, 'assign'])
                ->name('enquiries.assign');
            $router->post('crm/enquiries/{enquiry}/subscribers', [EnquiryController::class, 'subscribe'])
                ->name('enquiries.subscribers.store');
            $router->post('crm/enquiries/{enquiry}/set-status', [EnquiryController::class, 'setStatus'])
                ->name('enquiries.set-status');
            $router->post('crm/enquiries/{enquiry}/add-message', [EnquiryController::class, 'addMessage'])
                ->name('enquiries.addMessage');
            $router->get('crm/enquiries/{enquiry}/details', [EnquiryController::class, 'details'])
                ->name('enquiries.details');
            $router->get('crm/enquiries/filters', [EnquiryController::class, 'filters'])
                ->name('enquiries.filters');
            $router->resource('crm/enquiries', EnquiryController::class)->only(['index', 'show']);

            $router->apiResource('crm/enquiry-types', EnquiryTypeController::class);
            $router->apiResource('crm/enquiry-tags', EnquiryTagController::class);
            $router->apiResource('crm/enquiry-statuses', EnquiryStatusController::class);
        });


    $router->middleware(config('crm.route_middleware.forms'))
        ->group(function (Router $router) {
            $router->post('crm/forms/{form}/copy', [FormController::class, 'copy']);
            $router->resource('crm/forms', FormController::class)->only(['index', 'store', 'show', 'update', 'destroy']);
        });

});
