<?php

namespace Mtc\Crm\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;
use Mtc\Crm\Contracts\EnquiryModel;

class NewEnquiryMail extends Mailable
{
    use Queueable;
    use SerializesModels;

    /**
     * Create a new notification instance.
     *
     * @return void
     */
    public function __construct(
        protected readonly EnquiryModel $enquiry,
    ) {
        //
    }

    /**
     * Build the message.
     *
     * @return $this
     */
    public function build(): self
    {
        return $this
            ->subject('A new enquiry submitted #' . $this->enquiry->id . ' - ' . config('app.name'))
            ->line('Title: ' . $this->enquiry->title)
            ->line('Submitted by: ' . $this->enquiry->email)
            ->action('View Enquiry', url('/'))
            ->line('Message:')
            ->line($this->enquiry->message);
    }
}
