<?php

namespace Mtc\Crm\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class EnquiryViewResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param Request $request
     * @return array
     */
    public function toArray($request)
    {
        $this->resource
            ->load([
                'status',
                'messages',
                'tags',
                'assignee',
                'subscribers'
            ]);
        $this->resource->last_interaction_diff = $this->resource->updated_at->diffForHumans();
        $this->resource->created_at_formatted = $this->resource->created_at->format('d/m/Y H:i');
        $this->resource->created_at_diff = $this->resource->created_at->diffForHumans();

        $this->resource->subscribers->each(function ($subscriber) {
            $subscriber->setVisible(['id', 'name']);
        });
        return parent::toArray($request);
    }
}
