<?php

namespace Mtc\Crm\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Mail\Mailables\Address;
use Illuminate\Mail\Mailables\Content;
use Illuminate\Mail\Mailables\Envelope;
use Illuminate\Queue\SerializesModels;
use Mtc\Crm\Contracts\EnquiryModel;

class NewEnquiryMail extends Mailable
{
    use Queueable;
    use SerializesModels;

    /**
     * Create a new notification instance.
     *
     * @return void
     */
    public function __construct(
        public readonly EnquiryModel $enquiry,
    ) {

        $action = $this->enquiry->actions->where('action_name', 'send-copy-via-mail')->first();
        if ($action) {
            $this->enquiry->subject = $action->data['enquiry_subject'] ?? '';
            $this->enquiry->intro = $action->data['enquiry_content'] ?? '';
        }
    }

    public function envelope(): Envelope
    {
        return new Envelope(
            from: new Address(config('mail.from.address'), config('mail.from.name')),
            subject: __('crm::enquiries.new-enquiry', ['title' => $this->enquiry->title]),
        );
    }

    public function content(): Content
    {
        return new Content(
            view: 'crm::emails.new-enquiry',
        );
    }
}
