<?php

namespace Mtc\Crm\Factories;

use Illuminate\Database\Eloquent\Factories\Factory;
use Mtc\Crm\Models\FormQuestion;

class FormQuestionFactory extends Factory
{
    protected $model = FormQuestion::class;

    /**
     * Define the model's default state.
     *
     * @return array
     * @throws \Exception
     */
    public function definition()
    {
        return [
            'form_id' => random_int(1, 100),
            'form_section_id' => random_int(1, 100),
            'name' => $this->faker->word(),
            'type' => $this->faker->word(),
            'is_active' => random_int(0, 1),
            'is_customers_email' => random_int(0, 5),
            'is_enquiry_subject' => random_int(0, 5),
            'description' => $this->faker->paragraph(),
            'placeholder' => $this->faker->sentence(),
            'answer_options' => json_encode([]),
            'data' => json_encode([]),
            'settings' => json_encode([]),
            'order' => random_int(1, 100),
        ];
    }
}
