<?php

namespace Mtc\Crm\Factories;

use Illuminate\Database\Eloquent\Factories\Factory;
use Mtc\Crm\Models\FormSection;

class FormSectionFactory extends Factory
{
    protected $model = FormSection::class;

    /**
     * Define the model's default state.
     *
     * @return array
     * @throws \Exception
     */
    public function definition()
    {
        return [
            'form_id' => random_int(1, 100),
            'name' => $this->faker->word(),
            'is_active' => random_int(0, 1),
            'settings' => json_encode([]),
            'order' => random_int(0, 100),
        ];
    }
}
