<?php

namespace Mtc\Crm\Contracts;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\MorphTo;
use Illuminate\Support\Facades\Config;
use Mtc\Crm\Factories\EnquiryObjectFactory;

abstract class EnquiryObjectModel extends Model
{
    use HasFactory;

    /**
     * @var string
     */
    protected $table = 'enquiry_objects';

    /**
     * @var string[]
     */
    protected $fillable = [
        'enquiry_id',
        'object_id',
        'object_type'
    ];


    /**
     * Model factory
     *
     * @return EnquiryObjectFactory
     */
    protected static function newFactory(): EnquiryObjectFactory
    {
        return EnquiryObjectFactory::new();
    }

    /**
     * Relationship with enquiry
     *
     * @return BelongsTo
     */
    public function enquiry(): BelongsTo
    {
        return $this->belongsTo(Config::get('crm.enquiry_model'), 'enquiry_id');
    }

    public function object(): MorphTo
    {
        return $this->morphTo('object');
    }
}
