<?php

namespace Mtc\Crm\Events;

use Illuminate\Broadcasting\InteractsWithSockets;
use Illuminate\Foundation\Events\Dispatchable;
use Illuminate\Queue\SerializesModels;
use Mtc\Crm\Contracts\EnquiryModel;

class UserAssignedToEnquiry
{
    use Dispatchable;
    use InteractsWithSockets;
    use SerializesModels;

    /**
     * Create a new event instance.
     *
     * @return void
     */
    public function __construct(
        public EnquiryModel $enquiry,
        public readonly int $user_id,
        public readonly int $current_user_id
    ) {
        //
    }
}
