<?php

namespace Mtc\Crm\Tests\Feature;

use Illuminate\Foundation\Testing\RefreshDatabase;
use Mtc\Crm\Models\EnquiryType;
use Mtc\Crm\Tests\AsUser;
use Mtc\Crm\Tests\TestCase;

class EnquiryTypeControllerTest extends TestCase
{
    use RefreshDatabase;
    use AsUser;

    public function testListTypes()
    {
        $this->asUser();
        $response = $this->get(route('enquiry-types.index'));

        $this->assertEquals(200, $response->status());
        $body = $response->getData(true);
        $this->assertEquals(0, $body['total']);

        EnquiryType::factory()->create(['name' => 'foo']);
        EnquiryType::factory()->create(['name' => 'baz']);
        EnquiryType::factory()->create(['name' => 'bar']);

        $response = $this->get(route('enquiry-types.index'));

        $body = $response->getData(true);
        $this->assertEquals(3, $body['total']);
    }

    public function testShowType()
    {
        $this->asUser();
        $type = EnquiryType::factory()->create([
            'name' => 'foo',
            'notes' => 'lorem ipsum'
        ]);

        $response = $this->get(route('enquiry-types.show', $type));

        $body = $response->getData();
        $this->assertEquals('foo', $body->name);
        $this->assertEquals('lorem ipsum', $body->notes);
    }

    public function testAddType()
    {
        $this->asUser();
        $response = $this->postJson(route('enquiry-types.store'), [
            'name' => 'foo'
        ]);

        $this->assertEquals(201, $response->getStatusCode());
        $data = $response->getData();
        $type = EnquiryType::query()->find($data->id);

        $this->assertInstanceOf(EnquiryType::class, $type);
        $this->assertEquals($type->id, $data->id);
        $this->assertEquals('foo', $type->name);
    }

    public function testUpdateType()
    {
        $this->asUser();
        $type = EnquiryType::factory()->create(['name' => 'foo']);

        $response = $this->put(route('enquiry-types.update', $type->id), [
            'name' => 'baz-bar'
        ]);

        $this->assertEquals(200, $response->getStatusCode());
        $type->refresh();

        $this->assertEquals('baz-bar', $type->name);
    }

    public function testRemoveType()
    {
        $this->asUser();
        $type = EnquiryType::factory()->create([
            'name' => 'foo',
            'notes' => 'lorem ipsum'
        ]);

        $response = $this->delete(route('enquiry-types.destroy', $type));
        $this->assertEquals(200, $response->getStatusCode());

        $response = $this->get(route('enquiry-types.show', $type));
        $this->assertEquals(404, $response->getStatusCode());
    }
}
