<?php

namespace Mtc\Crm\Console\Commands;

use Illuminate\Support\Facades\App;
use Mtc\Crm\Contracts\EnquiryModel;
use Mtc\Crm\Jobs\ProcessIncomingEnquiryJob;
use Illuminate\Console\Command;
use Illuminate\Foundation\Bus\DispatchesJobs;

class IngestEnquiries extends Command
{
    use DispatchesJobs;

    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'enquiries:ingest';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Process new incoming enquiries';

    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {
        $model = config('crm.enquiry_model');
        $model::query()
            ->where('status_id', '>', 0)
            ->whereNull('ingested_at')
            ->get()
            ->each(fn(EnquiryModel $enquiry) => $this->dispatch(new ProcessIncomingEnquiryJob($enquiry)));

        return 0;
    }
}
