<?php

namespace App\Console\Commands;

use App\Src\Encryption;
use Illuminate\Console\Command;

class DecryptDbFields extends Command
{
    protected $signature = 'decryption:run';

    protected $description = 'Decrypts all fields marked as "encrypted" in the database.';

    public function handle(): int
    {
        foreach (Encryption::$modelsWithEncryption as $model) {
            try {
                Encryption::decrypt($model);
                $this->info("Decrypted fields for model: {$model}");
            } catch (\Throwable $exception) {
                $this->error("Decryption failed for model {$model}: {$exception->getMessage()}");
            }
        }

        $this->info('Decryption completed.');

        return self::SUCCESS;
    }
}
