<?php

namespace App\Src;

use Illuminate\Support\Facades\Config;
use Mtcmedia\EncryptionModule\Support\ModelEncryptor;

class Encryption extends ModelEncryptor
{
    /**
     * Default model list mirrors the legacy configuration.
     *
     * Projects can override this array at runtime or via config/encryption-module.php.
     *
     * @var array<int, class-string<\Illuminate\Database\Eloquent\Model>>
     */
    public static array $modelsWithEncryption = [];

    public static function encryptAll(?int $chunkSize = null): void
    {
        foreach (self::models() as $model) {
            parent::encrypt($model, $chunkSize);
        }
    }

    public static function decryptAll(?int $chunkSize = null): void
    {
        foreach (self::models() as $model) {
            parent::decrypt($model, $chunkSize);
        }
    }

    private static function models(): array
    {
        return Config::get('encryption-module.models', self::$modelsWithEncryption);
    }
}
