<?php

namespace Mtcmedia\EncryptionModule\Casts;

use Illuminate\Contracts\Database\Eloquent\CastsAttributes;
use Illuminate\Contracts\Encryption\DecryptException;
use Illuminate\Support\Facades\Config;
use Illuminate\Support\Facades\Crypt;

class OptionalEncrypted implements CastsAttributes
{
    /**
     * Decrypt the stored attribute value when encryption is enabled.
     *
     * @param  \Illuminate\Database\Eloquent\Model  $model
     * @param  string  $key
     * @param  mixed  $value
     * @param  array<string, mixed>  $attributes
     * @return mixed
     */
    public function get($model, string $key, $value, array $attributes)
    {
        if (!$this->isEnabled() || $value === null || $value === '') {
            return $value;
        }

        try {
            return Crypt::decryptString($value);
        } catch (DecryptException) {
            return null;
        }
    }

    /**
     * Encrypt the attribute before persisting when enabled.
     *
     * @param  \Illuminate\Database\Eloquent\Model  $model
     * @param  string  $key
     * @param  mixed  $value
     * @param  array<string, mixed>  $attributes
     * @return mixed
     */
    public function set($model, string $key, $value, array $attributes)
    {
        if (!$this->isEnabled() || $value === null || $value === '') {
            return $value;
        }

        return Crypt::encryptString((string) $value);
    }

    private function isEnabled(): bool
    {
        return (bool) Config::get(
            'encryption-module.enabled',
            Config::get('encryption.enabled', true)
        );
    }
}
