<?php

namespace Mtcmedia\EncryptionModule;

use Illuminate\Contracts\Support\DeferrableProvider;
use Illuminate\Support\ServiceProvider;
use Mtcmedia\EncryptionModule\Console\DecryptModels;
use Mtcmedia\EncryptionModule\Console\EncryptModels;
use Mtcmedia\EncryptionModule\Services\FileEncrypter;

class EncryptionModuleServiceProvider extends ServiceProvider implements DeferrableProvider
{
    /**
     * Bootstrap any application services.
     */
    public function boot(): void
    {
        $this->publishes([
            __DIR__ . '/../config/encryption-module.php' => config_path('encryption-module.php'),
        ], 'config');

        if ($this->app->runningInConsole()) {
            $this->commands([
                EncryptModels::class,
                DecryptModels::class,
            ]);
        }
    }

    /**
     * Register any application services.
     */
    public function register(): void
    {
        $this->mergeConfigFrom(__DIR__ . '/../config/encryption-module.php', 'encryption-module');

        $this->app->singleton(FileEncrypter::class, function ($app) {
            $config = $app['config']->get('encryption-module');

            return new FileEncrypter(
                $app['filesystem'],
                (string) ($config['file']['suffix'] ?? '.enc'),
                (bool) ($config['enabled'] ?? true)
            );
        });

        if (class_exists(\App\Src\Encryption::class)) {
            \App\Src\Encryption::$modelsWithEncryption = $this->app['config']->get(
                'encryption-module.models',
                \App\Src\Encryption::$modelsWithEncryption
            );
        }
    }

    /**
     * Get the services provided by the provider.
     *
     * @return array<int, string>
     */
    public function provides(): array
    {
        return [
            FileEncrypter::class,
        ];
    }
}
