<?php

namespace Mtc\Events\Http\Controllers;

use Illuminate\Http\Request;
use Mtc\Core\Http\Controllers\Controller;
use Mtc\Events\EventCategory;
use Mtc\Events\Http\Requests\SaveEventCategoryRequest;

class EventCategoryAdminController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return string
     */
    public function index(Request $request)
    {
        if ($request->wantsJson()) {
            return EventCategory::all();
        }

        $this->page_meta['title'] = 'Manage Event Categories';
        return template('admin/events/categories.twig', [
            'page_meta' => $this->page_meta,
        ]);
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param SaveEventCategoryRequest $request
     * @return \Illuminate\Http\Response
     */
    public function store(SaveEventCategoryRequest $request)
    {
        EventCategory::query()
            ->create([
                'name' => $request->input('name'),
                'active' => $request->input('active', 0),
            ]);

        return response('success');
    }

    /**
     * Update the specified resource in storage.
     *
     * @param SaveEventCategoryRequest $request
     * @param EventCategory $taxonomy
     * @return \Illuminate\Http\Response
     */
    public function update(SaveEventCategoryRequest $request, EventCategory $category)
    {
        $category->fill($request->input());
        $category->save();
        return response('success');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param EventCategory $taxonomy
     * @return \Illuminate\Http\Response
     */
    public function destroy(Request $request, EventCategory $category)
    {
        $category->delete();
        return response('success');
    }

    /**
     * Change the active state for category
     *
     * @param EventCategory $taxonomy
     * @return \Illuminate\Contracts\Routing\ResponseFactory|\Illuminate\Http\Response
     */
    public function togglePublished(EventCategory $category)
    {
        $category->published = !$category->published;
        $category->save();
        return response('success');
    }
}
