<?php

namespace Mtc\Events\Http\Requests;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\ModelNotFoundException;
use Illuminate\Foundation\Http\FormRequest;
use Mtc\Events\Event;

class ShowEventRequest extends FormRequest
{
    /**
     * @var Event
     */
    protected $event_model;

    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        if ($this->event()) {
            return $this->event()->published;
        }

        throw new ModelNotFoundException('Event not found', 404);
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [];
    }

    /**
     * @return Model|Event|null
     */
    public function event()
    {
        if ($this->event_model) {
            return $this->event_model;
        }

        return $this->event_model = Event::query()
            ->where('slug', $this->event)
            ->first();
    }
}
