<?php

namespace Mtc\Events\Providers;

use Illuminate\Database\Eloquent\Relations\Relation;
use Illuminate\Foundation\Support\Providers\EventServiceProvider;
use Illuminate\Support\Facades\Config;
use Illuminate\Support\Facades\Route;
use Mtc\Core\Facades\Media;
use Mtc\Events\Listeners\AddTicketsSectionToMembersArea;
use Mtc\Events\Listeners\CreateTicketsFromPaidOrder;
use Mtc\Events\Listeners\ViewPastEvents;
use Mtc\Members\Events\LoadMembersAreaSections;
use Mtc\Orders\Events\OrderPaid;

/**
 * Class EventProvider
 *
 * @package Mtc\BookableEvents\Providers
 */
class EventProvider extends EventServiceProvider
{
    /**
     * Register events
     *
     * @var array[]
     */
    protected $listen = [
        OrderPaid::class => [
            CreateTicketsFromPaidOrder::class,
        ],
        LoadMembersAreaSections::class => [
            AddTicketsSectionToMembersArea::class,
        ],
        'events_index_extra_actions' => [
            ViewPastEvents::class,
        ],

    ];

    /**
     * Register the application services.
     */
    public function register()
    {
        // Automatically apply the package configuration
        $this->mergeConfigFrom(dirname(__DIR__, 2) . '/config/events.php', 'events');

        //Check if package enabled
        if (Config::get('events.enabled', false) !== true) {
            return;
        }

        $this->registerBindings();
    }

    /**
     * Bootstrap the application services.
     */
    public function boot()
    {
        //Check if package enabled
        if (Config::get('events.enabled') !== true) {
            return;
        }

        Relation::morphMap([
            'event' => Config::get('events.event_class'),
            'ticket' => Config::get('events.ticket_class'),
        ]);

        // Load translations
        $this->loadTranslationsFrom(dirname(__DIR__, 2) . '/resources/lang', 'tickets');
        $this->loadViewsFrom(dirname(__DIR__, 2) . '/resources/views', 'events');
        app('twig_loader')->addPath(dirname(__DIR__, 2) . '/resources/templates');
        Media::addFolders('event_images', Config::get('events.image_folders'));

        if ($this->app->runningInConsole()) {
            $this->loadMigrationsFrom(dirname(__DIR__, 2) . '/database/migrations');
            $this->bootResourcePublish();
        }

        Route::middleware('web')->group(dirname(__DIR__, 2) . '/routes/web.php');
        parent::boot();
    }

    /**
     * Register bindings used by the package
     */
    protected function registerBindings()
    {
        //
    }

    /**
     * Register resources that get published
     */
    protected function bootResourcePublish()
    {
        $this->publishes([
            dirname(__DIR__, 2) . '/config/' => config_path()
        ], 'config');

        $this->publishes([
            dirname(__DIR__, 2) . '/resources/js/' => resource_path('js/vendor')
        ], 'assets');

        $this->publishes([
            dirname(__DIR__, 2) . '/resources/less/' => resource_path('less/vendor')
        ], 'assets');

        $this->publishes([
            dirname(__DIR__, 2) . '/resources/lang' => resource_path('lang/vendor/tickets'),
        ], 'lang');
    }
}
