<?php

namespace Mtc\Events;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Collection;
use Illuminate\Support\Facades\App;
use Mtc\Events\Factories\TicketFactory;
use Mtc\Members\Member;

/**
 * Class TicketManager
 *
 * @package Mtc\Events
 */
class TicketRepository
{
    /**
     * Create a new ticket
     *
     * @param $event_id
     * @param $order_data
     * @return mixed
     */
    public function create($event_id, $data, $type = 'order')
    {
        return App::make(TicketFactory::class)->create($event_id, $data, $type);
    }


    /**
     * Get events user has tickets
     *
     * @param Member $member
     * @param string $type
     * @return Collection
     */
    public function getUsersEvents($member, $type = 'upcoming')
    {
        return Event::query()
            ->orderBy('starts_at', 'desc')
            ->when($type === 'upcoming', function ($query) {
                return $query->where('ends_at', '>=', Carbon::now())
                    ->orderBy('starts_at', 'asc');
            })
            ->whereHas('tickets', function ($ticket_query) use ($member) {
                return $ticket_query->where('member_id', $member->id)
                    ->orWhere('email', $member->email);
            })
            ->get()
            ->each(function ($event) use ($member) {
                $event->member_tickets = $event->tickets()
                    ->where(function ($ticket_query) use ($member) {
                        $ticket_query->where('member_id', $member->id)
                            ->orWhere('email', $member->email);
                    })
                    ->get();
            });
    }
}