<?php

namespace Mtc\Events\Http\Controllers;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Config;
use Mtc\Core\Node;
use Mtc\Events\Event;
use Mtc\Events\Http\Requests\ShowEventRequest;

/**
 * Class EventController
 *
 * @package Mtc\Events\Http\Controllers
 */
class EventController extends Controller
{
    /**
     * List events
     *
     * @param Request $request
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     */
    public function index(Request $request)
    {
        $events = Event::query()
            ->active()
            ->upcoming()
            ->get();

        $this->page_meta['title'] = 'Events | ' . Config::get('app.name');
        return template('events/index.twig', [
            'page_meta' => $this->page_meta,
            'events' => $events,
        ]);
    }

    /**
     * View event
     *
     * @param ShowEventRequest $request
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     */
    public function show(ShowEventRequest $request)
    {
        $this->page_meta['title'] = $request->event()->name . ' | Events | ' . Config::get('app.name');
        return template('events/view.twig', [
            'page_meta' => $this->page_meta,
            'event' => $request->event()
        ]);
    }
}
