<?php

return [
    /*
    |--------------------------------------------------------------------------
    | Tickets package
    |--------------------------------------------------------------------------
    |
    | Enabled/disabled package
    */

    'enabled' => true,

    'ticket_purchasing' => true,
    'ticket_suffix_length' => 6,

    'public_url_slug' => 'events',
    'public_controller' => \Mtc\Events\Http\Controllers\EventController::class,

    'image_folders' => [
        "originals" => [
            "path" => "uploads/images/events/originals",
            "width" => 2000,
            "height" => 2000,
        ],
        "large" => [
            "path" => "uploads/images/events/large",
            "width" => 1360,
            "height" => 765,
            "crop" => 1
        ],
        "thumbs" => [
            "path" => "uploads/images/events/thumbs",
            "width" => 300,
            "height" => 200,
            "crop" => 1
        ],
        "mini" => [
            "path" => "uploads/images/events/mini",
            "width" => 50,
            "height" => 50,
            "crop" => 1
        ],
    ],

    /*
    |--------------------------------------------------------------------------
    | Class bindings
    |--------------------------------------------------------------------------
    |
    | These settings define classes that will be used by the application
    |
    */

    'event_class' => \Mtc\Events\Event::class,
    'ticket_class' => \Mtc\Events\Ticket::class,


];
