<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateEventsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('events', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->string('name');
            $table->string('slug')->index();
            $table->boolean('published')->index();
            $table->dateTime('starts_at')->index();
            $table->dateTime('ends_at')->index();
            $table->unsignedBigInteger('category_id')->nullable();
            $table->text('intro_text')->nullable();
            $table->text('description')->nullable();
            $table->string('image')->nullable();
            $table->string('location')->nullable();

            $table->decimal('ticket_price')->nullable();
            $table->dateTime('tickets_available_from')->nullable()->index();
            $table->dateTime('tickets_available_until')->nullable()->index();
            $table->unsignedInteger('total_ticket_count')->default(0)->nullable();
            $table->unsignedInteger('available_ticket_count')->default(0)->nullable()->index();
            $table->timestamps();
        });

        Schema::create('event_tickets', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->unsignedBigInteger('event_id')->index();
            $table->morphs('purchase');
            $table->unsignedBigInteger('member_id')->index()->nullable();
            $table->string('reference')->index();
            $table->string('customer_name')->nullable()->index();
            $table->string('email')->nullable()->index();
            $table->string('contact_number')->nullable()->index();
            $table->dateTime('redeemed_at')->nullable()->index();
            $table->timestamps();
            $table->softDeletes();
        });

        Schema::create('event_categories', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->string('name');
            $table->boolean('published')->index();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('events');
        Schema::dropIfExists('event_tickets');
        Schema::dropIfExists('event_categories');
    }
}
