<?php

namespace Mtc\Events;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Config;
use Mtc\Basket\Contracts\Purchasable;
use Mtc\Events\Http\Presenters\EventCategoryUrlPresenter;
use Mtc\Money\HasPrices;

/**
 * Class Ticket
 * @package Mtc\Tickets
 */
class EventCategory extends Model
{
    use HasPrices;

    /**
     * Price fields
     *
     * @var string[]
     */
    protected $price_fields = [
        'ticket_price'
    ];
    /**
     * @var array The attributes that are mass assignable.
     */
    protected $fillable = [
        'name',
        'published',
    ];

    /**
     * Cast attributes to specific types
     *
     * @var array
     */
    protected $casts = [
        'published' => 'boolean',
    ];

    /**
     * @var array
     */
    protected $appends = [
        'url',
        'edit',
    ];

    protected $hidden = [
        'created_at',
        'updated_at',
    ];

    /**
     * Relationship with events
     *
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     */
    public function events()
    {
        return $this->hasMany(Event::class, 'category_id');
    }

    /**
     * URL builder
     *
     * @return EventCategoryUrlPresenter
     */
    public function getUrlAttribute()
    {
        return new EventCategoryUrlPresenter($this);
    }

    /**
     * @return bool
     */
    public function getEditAttribute()
    {
        return false;
    }

}
