<?php

namespace Mtc\Events\Http\Controllers;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Response;
use Illuminate\Support\Facades\Storage;
use Mtc\Events\Event;
use Mtc\Events\Factories\TicketFactory;
use Mtc\Events\Mail\TicketEmail;
use Mtc\Events\Ticket;

/**
 * Class EventTemplateController
 *
 * @package Mtc\Events\Http\Controllers
 */
class EventTemplateController extends Controller
{
    /**
     * Render preview page
     *
     * @param Request $request
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     */
    public function index(Request $request)
    {
        $events = Event::query()
            ->paginate(25)
            ->appends($request->except('page'));

        $this->page_meta['title'] = 'Manage Events';
        return template('admin/events/templates.twig', [
            'page_meta' => $this->page_meta,
            'events' => $events
        ]);
    }

    /**
     * Render email preview
     *
     * @return TicketEmail
     */
    public function email()
    {
        $ticket = Ticket::query()->with('ticketEvent')->firstOrNew([]);
        return new TicketEmail([$ticket]);
    }

    /**
     * Render ticket html preview
     *
     * @param Request $request
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     */
    public function htmlTicket(Request $request, TicketFactory $factory)
    {
        /** @var Ticket $ticket */
        $ticket = Ticket::query()->with('ticketEvent')->firstOrNew([]);
        if (Storage::exists($ticket->getQRCodePath()) === false) {
            $factory->generateTicketQRCode($ticket);
        }

        return template('events/tickets/pdf_template.twig', [
            'ticket' => $ticket
        ]);
    }

    /**
     * Preview pdf ticket
     *
     * @param Request $request
     * @param TicketFactory $factory
     * @return mixed
     */
    public function pdfTicket(Request $request, TicketFactory $factory)
    {
        /** @var Ticket $ticket */
        $ticket = Ticket::query()->with('ticketEvent')->firstOrNew([]);
        $factory->generateTicketPdf($ticket);
        return Response::make(Storage::get($ticket->getTicketFileLocation()), 200, [
            'Content-Type' => 'application/pdf',
            'Content-Disposition' => 'inline; filename="' . $ticket->getTicketFilename() . '"'
        ]);
    }
}
