<?php

namespace Mtc\Events\Http\Controllers;

use Illuminate\Database\Eloquent\Relations\Relation;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Storage;
use Mtc\Core\Http\Controllers\Controller;
use Mtc\Events\Http\Requests\DownloadMemberTicketRequest;
use Mtc\Events\TicketRepository;
use Mtc\Members\Facades\MemberAuth;
use Mtc\Members\HasMembersNavigation;

/**
 * Class MyTicketsController
 *
 * @package Mtc\Events\Http\Controllers
 */
class MyTicketsController extends Controller
{
    use HasMembersNavigation;
    /**
     * View users tickets
     *
     * @param TicketRepository $repository
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     */
    public function index(Request $request, TicketRepository $repository)
    {
        $events = $repository->getUsersEvents(MemberAuth::user(), $request->input('type', 'upcoming'));

        $this->page_meta['title'] = 'My Tickets | ' . config('app.name');
        $this->page_meta['page_title'] = 'My Tickets';

        return template('events/members/index.twig', [
            'page_meta' => $this->page_meta,
            'events' => $events,
            'sections' => $this->sections(),
        ]);
    }

    /**
     * Download a ticket pdf
     *
     * @param DownloadMemberTicketRequest $request
     * @return mixed
     */
    public function download(DownloadMemberTicketRequest $request)
    {
        return Storage::download($request->ticket()->getTicketFileLocation());
    }
}
