<?php

namespace Mtc\Events\Http\Requests;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\ModelNotFoundException;
use Illuminate\Foundation\Http\FormRequest;
use Mtc\Events\Event;
use Mtc\Events\Ticket;
use Mtc\Members\Facades\MemberAuth;

class DownloadMemberTicketRequest extends FormRequest
{
    /**
     * @var Event
     */
    protected $ticket_model;

    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        if ($this->ticket()) {
            return Ticket::query()
                ->where('member_id', MemberAuth::id())
                ->exists();
        }

        throw new ModelNotFoundException('Event not found', 404);
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [];
    }

    /**
     * @return Model|Ticket|null
     */
    public function ticket()
    {
        if ($this->ticket_model) {
            return $this->ticket_model;
        }

        return $this->ticket_model = Ticket::query()
            ->where('reference', $this->ticket)
            ->first();
    }
}
