<?php

namespace Mtc\Events\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Support\Facades\Auth;

class SaveEventRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return Auth::check();
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'name' => 'required',
            'description' => 'required',
            'category_id' => 'required|exists:event_categories,id',
            'ticket_price' => [
                config('events.ticket_purchasing') ? 'required' : 'sometimes',
                'numeric',
            ],
            'total_ticket_count' => [
                config('events.ticket_purchasing') ? 'required' : 'sometimes',
                'numeric',
            ],
            'starts_at' => 'required',
            'location' => 'required',
            'ends_at' => 'required',
        ];
    }
}
