<?php

namespace Mtc\Events\Seeds;

use Illuminate\Database\Seeder;
use Mtc\Core\Admin\Menu;

/**
 * Class EventMenuSeeder
 *
 * @package Mtc\Events
 */
class EventMenuSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        if (Menu::query()->where('permission_name', 'events')->exists()) {
            return;
        }

        $menu = Menu::query()
            ->create([
                'title' => 'Events',
                'icon' => 'fas fa-ticket-alt'
            ]);

        if ($menu->id) {
            $sub_menu = $this->getEntries();
            foreach ($sub_menu as $sub_menu_entry) {
                $roles = $sub_menu_entry['roles'] ?? [];
                unset($sub_menu_entry['roles']);
                $child = $menu->children()->create($sub_menu);
                \Mtc\Core\Admin\Menu::grantMenuPermissionToRole($child, $roles);
            }
        }
    }

    /**
     * Get admin menu (shop submenu) data
     *
     * @return array
     */
    protected function getEntries() : array
    {
        return [
            [
                'title' => 'Events',
                'path' => '/admin/events',
                'activePath' => '/admin/events',
                'constant' => '',
                'order' => 0,
                'roles' => [
                    'Administrator'
                ],
            ],
            [
                'title' => 'Event Categories',
                'path' => '/admin/events/categories',
                'activePath' => '/admin/events/categories',
                'constant' => '',
                'order' => 1,
                'roles' => [
                    'Administrator'
                ],
            ],
            [
                'title' => 'Event Emails / Templates',
                'path' => '/admin/events/templates',
                'activePath' => '/admin/events/templates',
                'constant' => '',
                'order' => 2,
            ],
        ];
    }
}
