# Product Filter system

This package provides a filter that can be used for creating a product listing page. It is the key element of 
creating a user journey to find the product they are looking for. 

## Installation

Install via composer
```bash
composer require mtcmedia/filter

# then
php artisan install:components
```

This tool primarily is built to work with mtc's ecommmerce system, but can be adapted to alternate data objects.


## Configuration

The system has been built to allow flexible management of elements in system. All major elements of the 
filter process will have ability to be configured or overwritten via extension.

## Filters

By default system does utilise following filtering options:

* Category
* Brand
* Size
* Colour
* Price
* Search term

These filters are defined in `config/filter.php` as `filters` array. If behaviour of any filter needs to change
the class can be updated in config with the new version that implements correct functionality. If additional 
filters are needed, they can be created via the following command and the 
_newly created class then needs to be added to config file_.  

```bash
php artisan make:product-filter MyFilterName
```

Filter creation can be customised to allow for some specific use cases:

* when creating for custom field, add `--custom-field=db_field`
* when url element is not a simple slug but pattern (e.g. price-from-X-to-Y), add `--custom-pattern`

```bash
php artisan make:product-filter RegionFilter --custom-field=region --custom-pattern 
```

More information about how filters work [can be found here](docs/filters.md)

## Sort options 

System does allow for various sorting options on results matching the criteria. By default system has:

* Latest Products (New Sdditions)
* Price - Descending
* Price - Ascending
* Alphabetical (A to Z)

Any additional sort choices can be added in `sort_options` section of the filter config. If user does not specify
a specific sort method via UI the `default_sort_choice` config value will be used to sort results.

If additional sort options are needed, they can be created via the following command and the 
_newly created class then needs to be added to config file_.

```bash
php artisan make:product-sort MySortOption
```

More information about how sorting works [can be found here](docs/sorting.md)

## Result display

Results are queried to database and retrieved based of the main product filtering class.
Class is specified in `filter_object` class. It is imperative to have the results in this 
object returned as an optimised response (i.e. resource of only necessary fields) to ensure
that no unnecessary data is transferred/loaded during filtering process. 

More information about how result display works [can be found here](docs/sorting.md)

## Display Limits

By Default pagination contains 15 results per page on display result. This can be adjusted based 
on design aspects keeping in mind that the number should be something that will work well with
full page display (usually 3 results per row) and mobile results.

For filters each section will display only few results (amount controlled by `filter_limit` value)
on initial load. If there are additional results to load the system will add load more options link
that will allow loading in additional choices. This allows having a lower page load time and 
less content on page before diving into results. By default system will use the product count 
to sort the order of top results to display. Alternate sorting method (like alphabetical) can be specified
via `filter_limit_type` value. Currently this support basic sort options, however  enhanced options
like sorting most popular selections (tracking filter click-trough) and trending filters
(tracking click-through over time for filters) are welcome additions.

## SEO

## Request Lifecycle

## UI structure 