<?php

namespace Mtc\Filter\Console\Commands;

use Illuminate\Console\Command;
use Illuminate\Support\Facades\File;
use Illuminate\Support\Str;
use Symfony\Component\Console\Input\InputOption;

class MakeFilter extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'make:filter {name} {--custom-pattern}';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Create a new filter';

    /**
     * Path where the newly created file be stored
     *
     * @var string
     */
    protected $destination_directory = 'app/Filter/Filters/';

    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {
        $class_name = Str::studly($this->argument('name'));
        $content = File::get($this->template());
        $content = str_replace('{{ClassName}}', $class_name, $content);

        File::ensureDirectoryExists(base_path($this->destination_directory));
        File::put(base_path($this->destination_directory . $class_name . '.php'), $content);

        $this->info('Filter option generated. Please add it to your filter config'
            . ' (config/filter.php => filters section).');
        return 0;
    }

    /**
     * Find which template to choose
     *
     * @return string
     */
    private function template()
    {
        return $this->option('custom-pattern-filter')
            ? __DIR__ . '/stubs/custom-pattern-filter.php.stub'
            : __DIR__ . '/stubs/filter.php.stub';
    }
}
