<?php

namespace Mtc\Filter\Contracts;

use Illuminate\Support\Collection;

interface FilterInstance
{
    public function parseRequest(): array;

    public function handle(): array;

    public function getFilters(): Collection;

    public function getSelections(string $type = null): array;

    /**
     * Build the URL of the page that has been viewed
     *
     * @param bool $absolute
     * @return string
     */
    public function getPageUrl(bool $absolute = true): string;

    /**
     * Get the current pagination page of the filter
     *
     * @return int
     */
    public function getCurrentPage(): int;

    public function urlForSelections(array $selections): string;
}
